/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.ar;

import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.ProblemAnalysisRoutine;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class CommonServiceAnalysisRoutine
extends ProblemAnalysisRoutine {
    private static final String TRACE_MASKT = "XPACSART";
    private static final String TRACE_MASKF = "XPACSARF";
    private static final String TRACE_MASKD = "XPACSARD";
    private static final boolean UNIT_TEST = true;
    private PASystem system = null;
    protected static HashMap _pendingPoolMap = new HashMap(5);
    private static HashMap _analyzingPoolMap = new HashMap(5);

    public PASystem getSystem() {
        return this.system;
    }

    public void setSystem(PASystem system) {
        this.system = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncidentPool getPendingIncidentPool(String poolId) {
        Trace.trace(TRACE_MASKF, "getting the incident pool [" + poolId + "]");
        IncidentPool aPool = null;
        HashMap hashMap = _pendingPoolMap;
        synchronized (hashMap) {
            aPool = (IncidentPool)_pendingPoolMap.get(poolId);
            if (aPool == null) {
                Trace.trace(TRACE_MASKF, "didn't find the ip key. New up one.");
                aPool = new IncidentPool(poolId);
                _pendingPoolMap.put(poolId, aPool);
                Log theLog = new Log(-86, 70, 0, "PA START", null, null, null, null);
                String dataString = "created pool id=" + poolId;
                theLog.add((byte)3, dataString);
                theLog.log();
            } else {
                Trace.trace(TRACE_MASKF, "already have pool with id [" + poolId + "]");
            }
        }
        return aPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncidentPool getAnalyzingIncidentPool(String poolId) {
        IncidentPool aPool = null;
        HashMap hashMap = _analyzingPoolMap;
        synchronized (hashMap) {
            aPool = (IncidentPool)_analyzingPoolMap.get(poolId);
        }
        return aPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IncidentPool swapPendingIncidentPool(String poolId) {
        Trace.trace(TRACE_MASKF, "--> swapPendingIncidentPool(" + poolId + ")");
        IncidentPool aPool = null;
        HashMap hashMap = _pendingPoolMap;
        synchronized (hashMap) {
            aPool = (IncidentPool)_pendingPoolMap.remove(poolId);
            Trace.trace(TRACE_MASKD, "the pool size is now " + _pendingPoolMap.size());
            if (aPool != null) {
                HashMap hashMap2 = _analyzingPoolMap;
                synchronized (hashMap2) {
                    String newPoolId = this.buildAnalyzingPoolId(poolId);
                    aPool.setPoolId(newPoolId);
                    _analyzingPoolMap.put(newPoolId, aPool);
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<-- swapPendingIncidentPool()");
        return aPool;
    }

    private String buildAnalyzingPoolId(String pendingPoolId) {
        return new String(pendingPoolId + "//" + new Long(new Date().getTime()).toString());
    }

    public static long getAnalyzingPoolCreationTime(String analyzingPoolId) {
        String tsString = analyzingPoolId.substring(analyzingPoolId.lastIndexOf("//") + "//".length());
        return new Long(tsString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAnalyzingIncidentPool(String poolId) {
        Trace.trace(TRACE_MASKF, "--> removing [" + poolId + "]");
        int poolSize = 0;
        HashMap hashMap = _analyzingPoolMap;
        synchronized (hashMap) {
            Trace.trace(TRACE_MASKD, "found it in the map");
            poolSize = ((IncidentPool)_analyzingPoolMap.get(poolId)).size();
            _analyzingPoolMap.remove(poolId);
        }
        Log theLog = new Log(-86, 70, 0, "PA END", null, null, null, null);
        String dataString = "anlz pool id=" + poolId + "; num evts=" + poolSize;
        theLog.add((byte)3, dataString);
        theLog.log();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAnalyzingIncidentPoolIdSet() {
        HashSet<String> idSet = new HashSet<String>();
        HashMap hashMap = _analyzingPoolMap;
        synchronized (hashMap) {
            Set keySet = _analyzingPoolMap.keySet();
            Iterator keyIter = keySet.iterator();
            while (keyIter.hasNext()) {
                idSet.add((String)keyIter.next());
            }
        }
        return idSet;
    }

    protected void postServiceAREvent(CommonServiceAREvent theEvent, PASystem system, String poolId) {
        Trace.trace(TRACE_MASKD, "--> postServiceAREvent");
        theEvent.setSystem(system);
        theEvent.setIncidentPoolId(poolId);
        try {
            Trace.trace(TRACE_MASKD, "post the event");
            this.eventManager.handleEvent(theEvent);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "exception");
            Trace.trace(TRACE_MASKD, e);
        }
        Trace.trace(TRACE_MASKD, "<-- postServiceAREvent");
    }

    protected List sortIncidentPool(IncidentPool thePool) {
        ArrayList sortList = new ArrayList();
        if (thePool.size() != 0) {
            Iterator poolIterator = thePool.iterator();
            while (poolIterator.hasNext()) {
                sortList.add(poolIterator.next());
            }
            Collections.sort(sortList);
            CommonServiceIncident anIncident = null;
            Trace.trace(TRACE_MASKD, ">>>>> Sorted list <<<<<");
            for (int i = 0; i < sortList.size(); ++i) {
                anIncident = (CommonServiceIncident)sortList.get(i);
                Trace.trace(TRACE_MASKD, "refcode[" + i + "] =" + anIncident.getProblem().getRefcode());
            }
        }
        return sortList;
    }

    protected ArrayList getPools(String poolId, String timeInterval) {
        ArrayList<IncidentPool> pools = new ArrayList<IncidentPool>();
        Set pendingPoolKeys = _pendingPoolMap.keySet();
        Iterator ppKI = pendingPoolKeys.iterator();
        long timeSpan = Long.parseLong(timeInterval);
        long ourTimeSpanEnd = new Long(new Date().getTime() + timeSpan);
        while (ppKI.hasNext()) {
            String thisKey = (String)ppKI.next();
            if (thisKey.indexOf(poolId) == -1) continue;
            pools.add((IncidentPool)_pendingPoolMap.get(thisKey));
        }
        Set allAnalyzingPoolsKeys = CommonServiceAnalysisRoutine.getAnalyzingIncidentPoolIdSet();
        Iterator aapkI = allAnalyzingPoolsKeys.iterator();
        while (aapkI.hasNext()) {
            String thisKey = (String)aapkI.next();
            if (thisKey.indexOf(poolId) == -1) continue;
            if (timeSpan == 0L) {
                pools.add((IncidentPool)_analyzingPoolMap.get(thisKey));
                continue;
            }
            if (Long.parseLong(thisKey.substring(thisKey.lastIndexOf("//"))) > ourTimeSpanEnd) continue;
            pools.add((IncidentPool)_analyzingPoolMap.get(thisKey));
        }
        return pools;
    }

    public static void paNothing() {
        Log theLog = new Log(-86, 70, 0, "PA NOTHING", null, null, null, null);
        theLog.add((byte)3, "PA NOTHING");
        theLog.log();
    }

    public static void paStart() {
        Log theLog = new Log(-86, 70, 0, "PA START", null, null, null, null);
        theLog.add((byte)3, "PA START");
        theLog.log();
    }

    public static void paEnd() {
        Log theLog = new Log(-86, 70, 0, "PA END", null, null, null, null);
        theLog.add((byte)3, "PA END");
        theLog.log();
    }
}

